//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// FunctionObjects.cpp : Definiuje punkt wejcia dla aplikacji konsoli.
//

#include "stdafx.h"
#include <iostream>
#include <vector>
#include <algorithm>

template <class T>
int comparefunc (const T& a, const T& b)
{
     if(a < b) return -1;
	 else if(a == b) return 0;
	 else return 1;
}


template <class T> struct compareobj {
public:
  int operator () (T a, T b)
   { 
     if(a < b) return -1;
	 else if(a == b) return 0;
	 else return 1;
   }
};


int _tmain(int argc, _TCHAR* argv[])
{
	compareobj<int> mycompare;

	int result  = mycompare(1,2);
	if(result < 0)
		std::cout << _T("mniejszy") << std::endl;
	else if(result == 0)
		std::cout << _T("rwny") << std::endl;
	else
		std::cout << _T("wikszy") << std::endl;

	result  = comparefunc(1,2);
	if(result < 0)
		std::cout << _T("mniejszy") << std::endl;
	else if(result == 0)
		std::cout << _T("rwny") << std::endl;
	else
		std::cout << _T("wikszy") << std::endl;

	std::vector<int> v;
	v.push_back(1);
	v.push_back(2);
	std::sort(v.begin(), v.end(), mycompare);
	std::vector<int>::const_iterator iti;
	for(iti = v.begin(); iti < v.end(); iti++)
		std::cout << *iti << std::endl;

	std::vector<double> d;
	d.push_back(1.0);
	d.push_back(1.1);
	d.push_back(1.2);
	d.push_back(1.3);
	std::sort(d.begin(), d.end(), mycompare);
	std::vector<double>::const_iterator itd;
	for(itd = d.begin(); itd < d.end(); itd++)
		std::cout << *itd << std::endl;

	return 0;
}

